const log=console.log

let docType

if (window.location.href.includes('presentation')) docType='presentation'
else docType='document'

function cleanUpComment(comment){
  let cleanedUpComment='' 
  comment.split('').forEach((char,index,array)=>{
      if (!(char==='◌̲'[1] && ['q','y','p','g','j',' ','\n',
        '~','!','@','#','$','%','^','&','*','(',')','_','+','{','}',
        '|',':','"','<','>','?','`','-','=','[',']','\\',';',"'",
        ',','.','/'].includes(array[index-1]))){
        cleanedUpComment+=char
      }
    })
  return cleanedUpComment
}

function download(content, fileName, contentType) {
    var a = document.createElement("a");
    var file = new Blob([JSON.stringify(content)], {type: contentType});
    a.href = URL.createObjectURL(file);
    a.download = fileName;
    a.click();
}

let exportNames={elementary:'Grades 3-6',middle:'Grades 6-9',
                high:'Grades 9-12',college:'College and Workplace'}
function createDownload(json,type){
  let date= new Date()
  let fileName
  if(type=="commentSet") fileName = exportNames[currentCommentSet]+' Backup '+date.toLocaleString().split('/').join('.')+'.json'
  if(type=="commentCategory") {
    json.setName=currentCommentSet
    fileName = exportNames[currentCommentSet]+' '+json.name+' Backup '+date.toLocaleString().split('/').join('.')+'.json'
  }
  download(json, fileName, 'text/plain');
}


function capitalizeSentences(text){
  let output='',last=undefined,secondLast=undefined,lastNonSpace=undefined
  text.split('').forEach((char,i,arr)=>{
    if (!last || lastNonSpace==='\n' ||
      (last===' ' && ['.','!','?','▪'].includes(secondLast))) output+=char.toUpperCase()
    else output+=char
    if (!['-','*','_'].includes(char)){
      last=char
    }
    if(!['-','*','_'].includes(arr[i-1])){
      secondLast=arr[i-1]
    }
    if (char!==' ')lastNonSpace=char
  })
  return output
}

function scrolltoBottom(){
  setTimeout(()=>{
   var element = document.querySelector('#e-commments-style-root')
   element.scrollTop = element.scrollHeight - element.clientHeight;
  },100)
}

let triesLeft=3
async function addCommentToDoc(comment){
  try{
    openBubble()
  }
  catch(e){
    console.log('nothing selected')
    return
  }
  try{
    if (triesLeft==0){
      triesLeft=3
      return
    }
    else triesLeft--
    await timeout(100)
    addText(comment)
    await timeout(100)
    focusOnTextarea()
    await timeout(100)
    postComment()
    triesLeft=3
  }
  catch(e){
    console.log('couldnt post retrying')
    addCommentToDoc(comment)
  }
  await timeout(100)
  if (document.querySelector('[data-tooltip="Post Comment"]'))postComment()
}
async function timeout(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
function openBubble(){
  //if (docType=='presentation')simulateMouseClick('#insertCommentButton')
  //else simulateMouseClick('#docs-instant-button-bubble')
  simulateMouseClick('#insertCommentButton')
}

function getTextBox(){
  let textboxes
  if (docType=='presentation') textboxes= document.getElementsByClassName('dcs-a-dcs-db-dcs-df')
  else textboxes= document.getElementsByClassName('docos-input-textarea')
  return textboxes[textboxes.length-1]  
}

function addText(comment){
  let textbox=getTextBox()
  textbox.value=comment
}
function focusOnTextarea(){
  let textbox=getTextBox()
  simulateMouseClick(textbox,true)
}

function postComment(){
  simulateMouseClick('[data-tooltip="Post Comment"]')
}

function simulateMouseClick(el,isDOMel){
  dispatchMouseEvent("mouseover",el,isDOMel);
  dispatchMouseEvent("mousedown",el,isDOMel);
  dispatchMouseEvent("mouseup",el,isDOMel);
  dispatchMouseEvent("click",el,isDOMel);
}

function dispatchMouseEvent(eventType,el,isDOMel){
  let evt = document.createEvent('MouseEvents');
  evt.initMouseEvent(eventType, true, true)
  if (isDOMel)el.dispatchEvent(evt);
  else document.querySelector(el).dispatchEvent(evt);
}


function getSelectionData(contents,selectionStart,selectionEnd){
  let currentPosition=selectionStart,startLine,startLetter,endLine,endLetter
  contents.slice(selectionStart,selectionEnd)
  .split('\n').forEach((line,lineIndex,arr)=>{
    line.split('').forEach((letter,letterIndex)=>{    
      if (currentPosition==selectionStart){
        startLine=lineIndex
        startLetter=letterIndex
      }
        //console.log(currentPosition,selectionEnd)

      if (currentPosition==selectionEnd){
        endLine=lineIndex
        endLetter=letterIndex
      }
      currentPosition++
    })
  })
//  console.log(contents)
  //console.log('startLine',startLine,'endLine',endLine)
  //console.log({startLine,startLetter,endLine,endLetter,isMultiline:startLine!=endLine})
  return {startLine,startLetter,endLine,endLetter,isMultiline:startLine!=endLine}
}


function decorateSingleLine(decorator,contents,selectionStart,selectionEnd){
  
  if (selectionEnd-selectionStart==0 && 
      contents[selectionStart-1]===decorator &&
      contents[selectionStart]===decorator){
    return contents.slice(0, selectionStart-1)+contents.slice(selectionEnd+1);
  }
  // if ((this.contents[selectionStart-1]==decorator||
  //  this.contents[selectionStart+1]==decorator)&&
  //  (this.contents[selectionStart-1]==decorator||
  //  this.contents[selectionStart+1]==decorator)){
  //  this.removeDecoration(decorator)
  //  return;
  // }

  //open tag
  let open=contents.slice(0, selectionStart)
  +decorator+contents.slice(selectionStart)
  //close tag
  return open.slice(0, selectionEnd+1)+decorator+open.slice(selectionEnd+1);
}


function decorateMultiLine(decorator,contents,startLine,startLetter,endLine,endLetter){
  
}



function isSpecialChar(c){
  if (c<48 ||(c>57 && c<65) || (c>90 && c<97) || (c>122 && c<127) ) return true
}
let styles=['*','_','-']

function isValidDecorator(charBefore,charAfter){
  if ((charAfter!==' ' && (charBefore===undefined || isSpecialChar(charBefore))) ||
      (charBefore!==' ' && (charAfter===undefined || isSpecialChar(charAfter)))
     ) return true
  return false
}

let openStyleTypes={
  '*':"<span style='font-weight:bold'>",
  '_':"<span style='font-style: italic'>",
  '-':"<span style='text-decoration: line-through'>",
}

function styleText(text,type){
  let lines = text.split('\n')
  let result =[]
  lines.forEach(line=>{
    let styledLine=[]
    let styleStates={'*':'open','_':'open','-':'open'}
    let lastStyleOpenIndex={'*':undefined,'_':undefined,'-':undefined}
    line.split('').forEach((letter,index)=>{
      if (letter in openStyleTypes){
        if (styleStates[letter]==='open' && line[index+1]!==' ' && (index===0|| isSpecialChar(line.charCodeAt(index-1))) ){
          if (type==='editor') styledLine.push(openStyleTypes[letter]+letter)
          else styledLine.push(openStyleTypes[letter])
          styleStates[letter]='closed'
          lastStyleOpenIndex[letter]=index
        }
        else if (line[index-1]!==' ' && (index+1===line.length || isSpecialChar(line.charCodeAt(index+1))) ) {
          if (type==='editor') styledLine.push(letter+'</span>')
          else styledLine.push('</span>')
          styleStates[letter]='open'
          lastStyleOpenIndex[letter]=undefined
        }
        else styledLine.push(letter)
      }
      else if ((index===0 || index+1===line.length) && letter===" ") styledLine.push('&nbsp;') //messes up flow!
      else styledLine.push(letter)
    })
    styles.forEach(style=>{
      if (lastStyleOpenIndex[style]!==undefined)styledLine[lastStyleOpenIndex[style]]=line[lastStyleOpenIndex[style]]
    })
    result.push(styledLine.join(''))
  })
  return urlify(result.join('<br>'))+'<br>'
}

function copyToClipboard(text) {
  const el = document.createElement('textarea');
  el.value = text;
  document.body.appendChild(el);
  el.select();
  document.execCommand('copy');
  document.body.removeChild(el);
}


function getSelectionText() {
    var text = "";
    var activeEl = document.activeElement;
    var activeElTagName = activeEl ? activeEl.tagName.toLowerCase() : null;
    if (
      (activeElTagName == "textarea") || (activeElTagName == "input" &&
      /^(?:text|search|password|tel|url)$/i.test(activeEl.type)) &&
      (typeof activeEl.selectionStart == "number")
    ) {
        text = activeEl.value.slice(activeEl.selectionStart, activeEl.selectionEnd);
    } else if (window.getSelection) {
        text = window.getSelection().toString();
    }
    return text;
}

let selectedText
document.onmouseup = document.onkeyup = document.onselectionchange = function() {
   selectedText = getSelectionText()
};

function urlify(text) {
    var urlRegex = /(((https?:\/\/)|(www\.))[^\s|^\<|\)]+)/g;
    //var urlRegex = /(https?:\/\/[^\s]+)/g;
    return text.replace(urlRegex, function(url,b,c) {
        var url2 = (c == 'www.') ?  'http://' +url : url;
        return '<a href="' +url2+ '" target="_blank">' + url + '</a>';
    }) 
}

function dragElement(elmnt) {
  var pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
  
  elmnt.onmousedown = dragMouseDown;

  function dragMouseDown(e) {
    e = e || window.event;
    e.preventDefault();
    // get the mouse cursor position at startup:
    pos3 = e.clientX;
    pos4 = e.clientY;
    document.onmouseup = closeDragElement;
    // call a function whenever the cursor moves:
    document.onmousemove = elementDrag;
  }

  function elementDrag(e) {
    e = e || window.event;
    e.preventDefault();
    
    // calculate the new cursor position:
    pos1 = pos3 - e.clientX;
    pos2 = pos4 - e.clientY;
    pos3 = e.clientX;
    pos4 = e.clientY;

    // set the element's new position:
    let dragRoot = document.getElementById('drag-root')
    let mainDiv=document.getElementById('e-commments-style-root')
    
    let inboundsTop = dragRoot.offsetTop - pos2 > 0 ? dragRoot.offsetTop - pos2 : 0
    if (inboundsTop+mainDiv.offsetHeight>window.innerHeight) inboundsTop=window.innerHeight-mainDiv.offsetHeight
    let inboundsLeft = dragRoot.offsetLeft - pos1 > 0 ? dragRoot.offsetLeft - pos1 : 0
    if (inboundsLeft+mainDiv.offsetWidth>window.innerWidth) inboundsLeft=window.innerWidth-mainDiv.offsetWidth

    dragRoot.style.top = inboundsTop + "px";
    dragRoot.style.left = inboundsLeft + "px";
  }

  function closeDragElement() {
    // stop moving when mouse button is released:
    document.onmouseup = null;
    document.onmousemove = null;
  }
}

function makeDraggable(){
  // Make the DIV element draggable:
  categoryheaders= document.getElementsByClassName("commentCategoryHeader");
  for (let i=0;i<categoryheaders.length;i++){
    dragElement(categoryheaders[i]);
  }
}

function forceIntoWindow(){
  let dragRoot = document.getElementById('drag-root')
  let mainDiv=document.getElementById('e-commments-style-root')
  if (dragRoot.offsetTop+mainDiv.offsetHeight>window.innerHeight){
    dragRoot.style.top=window.innerHeight-mainDiv.offsetHeight+"px";
  }
}


//{
// categories:[
//    {
//      type:'default',
//      name:'default category',
//      comments:[
//        {
//          abbreviation:'missLet',
//          contents:`*missing letter:* \nAdd the letter that's missing. \n_Example: aple is missing 'p'_ \nworksheet link: www.google.com`
//        },
//        {
//          abbreviation:'cap',
//          contents:`*capitalization:* \nCapitalize first letter. \n_Example: New York worksheet_ \nlink: www.yahoo.com`
//        }
//      ]
//    },
//    {
//      type:'custom',
//      name:'custom user added category',
//      comments:[
//        {
//          abbreviation:'conj',
//          contents:`*needs conjugation:* \nAdd 'ing' to end of verb. \n_Example: the man is running worksheet_ \nlink: www.google.com`
//        },
//        {
//          abbreviation:'art',
//          contents:`*article:* \nadd an article. \n_Example: an apple, a banana worksheet_ \nlink: www.yahoo.com`
//        }
//      ]
//    }
//  ]
// }